/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package Main;        

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxCellRenderer.CanvasFactory;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.spi.DirStateFactory;
import javax.swing.JApplet;


/**
 *
 * @author mato
 */



public class Main extends JApplet{
    
    // v tejto premennej mame ulozene zarovnania
    public static ArrayList<Zarovnanie> zarovnania;
    // v tejto premennej mame ulozene segmenty (ready)
    public static ArrayList<Read> ready;
    // v tejto premennej mame ulozenu sekvenciu referencneho genu
    public static String gen;    
    
    //pole v ktorom je ulozeny pocet jednotilivych alternativ nachadzajucich na nejednoznacnych poziciach
    public static Policko[] tabulkaVrcholov;
    //pole v ktorom 0 znamena, že sa jedna o vrchol z varianty
    //ina hodnota vyjadruje, že ide o vrchol z referencnej sekvencie
    public static Policko[] typVrcholov;
    
    public static int[][] maticaSusednosti;
    public static int[][] vybrate_hrany;
    public static mxGraph mxgraf;
    public static ArrayList<Vrchol> Vrcholy;
    
    //dvojica premennych sluziaca na filtrovanie vrcholov a hran grafu variantov  
    public static double minVahaVrchola;
    public static int minVahaHrany;
    
    
    /**
     * nacita zarovnanie, vstupnych segmentov k referencnej sekvencii genu, pochadzajuceho z Blat-u
     * @param zarovnanie meno suboru v ktorom sa nachadza vystup z algoritmu Blat (format psl)
     * @param read meno suboru v ktorom sa nachadzaju segmenty (format fa)
     * @param g meno suboru v ktorom sa nachadza referencna sekvencia genu (format fa)
     * @param kvalita pocet baz, ktore su rovnake v sekvencii segmentu a useku ku ktoremu sa dany segment zarovnal (ide o parameter match vo formate psl)
     */
    public static void nacitaj(String zarovnanie, String read, String g, int kvalita) throws FileNotFoundException, IOException, Exception{                        
        BufferedReader reader = new BufferedReader(new FileReader(zarovnanie));
        String line = reader.readLine();
        
        //-----------------------------ZAROVNANIA-------------------------------
        // prvych 5 riadkov sa preskoci, lebo tvoria hlavicku
        int preskoc = 5;

        while (line != null){
            //preskocime hlavicku
            while (preskoc > 0){
                preskoc--;
                line = reader.readLine();
            }            
            
            // spracujeme jeden riadok
            String[] riadok = line.split("\t");
            // skontrolujeme ci dany riadok je vo formate psl
            if (riadok.length != 21){
                throw new Exception("Riadok nie je vo formáte PSL!!!");
            }
            
            // odfiltrovanie nekvalitnych readov s tym, že si berieme ready dlhe 101
            if ((Integer.valueOf(riadok[0]) >= kvalita) && (Integer.valueOf(riadok[10]) == 101)){
                //spracovanie jedneho zarovnania
                String[] v = riadok[18].split(",");
                String[] qs = riadok[19].split(",");
                String[] ts = riadok[20].split(",");
                int[] vv = new int[Integer.valueOf(riadok[17])], 
                      qq = new int[Integer.valueOf(riadok[17])],
                      qe = new int[Integer.valueOf(riadok[17])],
                      tt = new int[Integer.valueOf(riadok[17])], 
                      te = new int[Integer.valueOf(riadok[17])];
                for(int i=0; i<v.length; i++){
                    vv[i] = Integer.valueOf(v[i]);
                    qq[i] = Integer.valueOf(qs[i]);
                    qe[i] = vv[i] + qq[i];
                    tt[i] = Integer.valueOf(ts[i]);
                    te[i] = vv[i] + tt[i];
                }
                // pridame nove zarovnanie k ostatnym zarovnaniam meno, match, vlakno, velkost, qstarts, qends, tstarts, tends
                Zarovnanie z = new Zarovnanie(riadok[9], (Integer.valueOf(riadok[0])), riadok[8], vv, qq, qe, tt, te);
                zarovnania.add(z);
            }
            // nakoniec nacitame dalsi riadok
            line = reader.readLine();
        }
        reader.close();
        
        //---------------------------------READY--------------------------------        
        reader = new BufferedReader(new FileReader(read));
        String meno = reader.readLine();
        String sekvencia = reader.readLine();
        while((meno != null) && (sekvencia != null)){
            //pridame read
            if ((!("".equals(meno))) && (!("".equals(sekvencia)))){
                Read r = new Read(meno.substring(1, meno.length()), sekvencia);
                ready.add(r);
            }
            //nakoniec precitame dalsi riadok
            meno = reader.readLine();
            sekvencia = reader.readLine();
        }
        reader.close();
        
        //-----------------------------REFERENCIA-------------------------------
        reader = new BufferedReader(new FileReader(g));
        line = reader.readLine();
        //odfiltrujeme prvy riadok t.j. meno genu
        line = "";
        while(line != null){
            gen = gen + line;
            line = reader.readLine();
        }
        reader.close();
    }
    
    /**
     * Zmeni otocenie vstupneho readu
     * @param r read, ktory sa zarovnal ku komplementarnemu vlaknu
     * @return reverznuty read prelozeny do komplementarnych baz
     */
    public static String zmenOrientaciu(String r) {
        String vysledok = "";
        int i = 0;
        while (i < r.length()) {
            switch (r.charAt(i)){
                case 'A':   vysledok = "T" + vysledok;
                            break;
                case 'C':   vysledok = "G" + vysledok;
                            break;
                case 'G':   vysledok = "C" + vysledok;
                            break;
                case 'T':   vysledok = "A" + vysledok;
                            break;
                case 'N':   vysledok = "N" + vysledok;
                            break;
            }                                
            i++;
        }
        return vysledok;
    }
    
    /**
     * urci sekvenciu readu
     * @param z zarovnany read
     * @return sekvencia readu z (v kladnom smere)
     */
    public static String najdiSekvenciuReadu(Zarovnanie z){
        String result = "";
        for(Read r : ready){                        
            if (r.meno.equals(z.meno)) {
                result = r.sekvencia;
            }                        
        }
        
        result = result.substring(z.qstarts[0], z.qends[0]);
        
        // otocime si vlakno do kladneho smeru (ak je treba)             
        if (z.vlakno.equals("-")) {
            result = zmenOrientaciu(result);
        }
        return result;
    }
    
    /**
     * urci sekvenciu referencneho genu ktora sa zarovnala k readu
     * @param z zarovnany read
     * @return sekvencia referencneho genu
     */
    public static String najdiSekvenciuReferencie(Zarovnanie z){
        String result = "";                        
        int zaciatok = vratZaciatokIntervalu(z);               
        int koniec = vratKoniecIntervalu(z);
        result = gen.substring(zaciatok, koniec);
        return result;
    }    
    
    /**
     * Na zaklade vstupnych dat urci vrcholy pochadzajuce z variantov
     * ktore prida do grafu variantov prida 
     */
    public static void pridajVrcholyVariant(){
        for(Zarovnanie i : zarovnania){
            // nastal SNP - tstarts je jedno                        
            if (i.tstarts.length == 1){              
                // v si mame sekvenciu i-teho zarovanneho readu
                // v gi mame jemu zodpovedajuci usek v referencii
                String si = najdiSekvenciuReadu(i);
                String gi = najdiSekvenciuReferencie(i);
                
                //pridame vrcholy zodpovedajuce zarovnanemu readu i
                int pozicia_i = 0;
                String zmena_i = "";                                  
                // zistime všetky zmeny voči readu
                for(int k = 0; k<101; k++){                    
                    if ((k<si.length()) && (k<gi.length())){
                        if (!(si.substring(k, k+1).equals(gi.substring(k, k+1)))){
                           pozicia_i = k + i.tstarts[0];
                           zmena_i = si.substring(k, k+1);
                           tabulkaVrcholov[pozicia_i].zmen(zmena_i);                           
                           zmena_i = "";
                           pozicia_i = 0;
                        }
                    }                                                       
                }                                                       
            }
        }
    }
    
    
    /**
     * Na zaklade vrcholov z variant urci vrcholy pochadzajuce z referencie,
     * ktore prida do grafu variantov prida 
     * @param i vzhladom na ktory read pridavame referencne vrcholy
     */
    private static void pridajVrcholyReferencie(Zarovnanie i) {
        // postupne dostaneme na vstupe kazdy zarovnany read a zistujeme ci na pozicii nejakeho vrchola ma inu bazu ako je tam
        // teda pridavame vrcholy referencie
        if (i.tstarts.length == 1){ 
            // v si mame sekvenciu i-teho zarovanneho readu
            // v gi mame jemu zodpovedajuci usek v referencii
            String si = najdiSekvenciuReadu(i);
            String gi = najdiSekvenciuReferencie(i);
            //pozreime sa ktore vrcholy su v okne daneho readu a ak ma na danej pozicii inu bazu tak pridame novy vrchol
            //takto dostaneme referencne vrcholy                        
            int pozicia_i = 0;
            String zmena_i = "";    
            for(int k = 0; k<101; k++){                    
                if ((k<si.length()) && (k<gi.length())){
                    pozicia_i = k + i.tstarts[0];
                    zmena_i = si.substring(k, k+1);
                    String referencia = gi.substring(k, k+1);
                    int suma = tabulkaVrcholov[pozicia_i].scitaj(zmena_i);
                    if ((zmena_i.equals(referencia)) && (suma > 0)){
                        tabulkaVrcholov[pozicia_i].zmen(zmena_i); 
                        typVrcholov[pozicia_i].zmen(zmena_i);
                        zmena_i = "";
                        pozicia_i = 0;
                    }
                }                                                       
            }
            
        }       
    }
    
    /**
     * Hlada sparovany read k vstupnemu readu
     * tento read hladame medzi zarovnanymi readmi
     * @param i ku ktoremu readu hladame zarovnanie
     * @return pár k vstupnemu readu (ak neexstuje vrati sa null)
     */
    public static Zarovnanie najdiPar(Zarovnanie i){
        Zarovnanie result = null;
        int c;
        c = (Integer.valueOf(i.meno.substring(i.meno.length()-1)) % 2) + 1;
        // vyrobime si meno sparovaneho readu a pokusime sa ho najst medzi zarovnanymi readmi
        String meno = i.meno.substring(0, i.meno.length()-1) + String.valueOf(c);        
        for(Zarovnanie j : zarovnania){
            if (j.meno.equals(meno)) {
                result = j;
            }                
        }
        return result;
    }    
    
    public static int indexHrany(String zmena, int pozicia){
        int result = 5*pozicia;
        switch (zmena.charAt(0)){
            case 'A':   result = result + 0;
                        break;
            case 'C':   result = result + 1;
                        break;
            case 'G':   result = result + 2;
                        break;
            case 'T':   result = result + 3;
                        break;
            case 'N':   result = result + 4;
                        break;
            default:    result = result + 4;
                        break;
        }
        return result;    
    }
    
    /**
     * urci zaciatocnu poziciu na ktoru sa zarovnal dany read
     * @param i zarovnany read
     * @return pociatocna pozicia zarovnaneho readu v sekvencii referencneho readu
     */
    public static int vratZaciatokIntervalu(Zarovnanie i){
        int result = 0;
        result = i.tstarts[0];
        return result;
    }
    
    /**
     * urci koncovu poziciu na ktoru sa zarovnal dany read
     * @param i zarovnany read
     * @return koncova pozicia zarovnaneho readu v sekvencii referencneho readu
     */
    public static int vratKoniecIntervalu(Zarovnanie i){
        int result = 0;
        result = i.tends[0];
        return result;
    }
    
    /**
     * vytvori hrany grafu variantov na zaklade vstupnych sparovanych readov
     * @param i prvy par z dcojice
     * @param j druhy par z dovjice
     */
    public static void vytvorHrany(Zarovnanie i, Zarovnanie j){
        // postupne dostaneme kazdy zarovnany read, pozrieme si vrcholy ktore k nemu patria a tie spojime kazdy s kazdym
        if(i.nespracovany){
            // mnozina tych co chceme spojit
            ArrayList<Integer> kandidati = new ArrayList();
            String si = najdiSekvenciuReadu(i); 
            int pozicia_i = 0;
            String zmena_i = "";
            
            for(int k = 0; k<101; k++){                    
                if (k<si.length()){
                    pozicia_i = k + i.tstarts[0];
                    zmena_i = si.substring(k, k+1);                    
                    if (tabulkaVrcholov[pozicia_i].pocet(zmena_i)>0){
                        int index = indexHrany(zmena_i, pozicia_i);
                        kandidati.add(index);
                    }
                }                                                       
            }            

            if ((j!= null) && (j.nespracovany)){
                String sj = najdiSekvenciuReadu(j);
                int pozicia_j = 0;
                String zmena_j = "";

                for(int k = 0; k<101; k++){                    
                    if (k<sj.length()){
                        pozicia_j = k + j.tstarts[0];
                        zmena_j = sj.substring(k, k+1);                    
                        if (tabulkaVrcholov[pozicia_j].pocet(zmena_j)>0){
                            int index = indexHrany(zmena_j, pozicia_j);
                            kandidati.add(index);
                        }
                    }                                                       
                }               
                j.nespracovany = false;
            }
            for(Integer k : kandidati){
                for(Integer l : kandidati){                    
                    maticaSusednosti[k][l] = maticaSusednosti[k][l] + 1;
                }
            }
            i.nespracovany = false;
        }
    }
    
    /**
     * spracuje nacitane data (zarovnane ready) z ktorych vytvori graf variantov
     */
    public static void spracuj() throws Exception{        
        pridajVrcholyVariant();
        // na zaklade vrcholov z variantov pridame vrcholy z referencne vrcholy a hrany do grafu variantov
        for (Zarovnanie i : zarovnania){
            if ((i.nespracovany) && (i.tstarts.length == 1)) {                
                pridajVrcholyReferencie(i);            
                Zarovnanie j = najdiPar(i);
                if ((j != null) && (j.nespracovany) && (j.tstarts.length == 1)) {
                    pridajVrcholyReferencie(j);
                }
                vytvorHrany(i,j);
            }
        }
        
         for(int i=0; i<tabulkaVrcholov.length; i++) {
            tabulkaVrcholov[i].celkom();
        }       
    }
    
    public static String spocitaj(){    
        /*int max = 0;
        for(int i=0;i<(gen.length()*5);i++){
            for(int j=0;j<(gen.length()*5);j++){
                if (maticaSusednosti[i][j]>max){
                    max = maticaSusednosti[i][j];
                }
            }
        }*/

        int[] pocty = new int[102];
        for(int i = 0; i<pocty.length; i++){
            pocty[i] = 0;
        }
        
        for(int i = 0; i < zarovnania.size(); i++) {
            
        }
       
        String po = "";
        for(int i = 0; i<pocty.length; i++){
            po = po + " " + Integer.toString(pocty[i]);
        }
        return po;
    }
    
    public static void nakresliGraf(String meno) throws IOException{
        mxSvgCanvas canvas = (mxSvgCanvas) mxCellRenderer
            .drawCells(mxgraf, null, 1, null,
                new CanvasFactory(){
                    public mxICanvas createCanvas(int width, int height){
                        mxSvgCanvas canvas = new mxSvgCanvas(
                            mxDomUtils.createSvgDocument(width, height)
                        );
                        canvas.setEmbedded(true);
                        return canvas;
                    }

                });

    mxUtils.writeFile(mxXmlUtils.getXml(canvas.getDocument()),meno);
    }
    
    public static void spravGraf(int initX, int initY){     
        // inicializujeme graf
        Object parent = mxgraf.getDefaultParent();
        mxgraf.getModel().beginUpdate();
        ArrayList<Object> nodes = new ArrayList();
        //naplnime ho vrcholmi                                
        int x = initX, 
            staraPozicia = 0;
        try{
            for(int i=0;i<Vrcholy.size();i++){                
                if (staraPozicia != Vrcholy.get(i).pozicia){
                    staraPozicia = Vrcholy.get(i).pozicia;
                    x = x+100;                          
                }
                int y = initY;
                switch (Vrcholy.get(i).zmena.charAt(0)){
                    case 'A': y = 40;                                
                              break;
                    case 'C': y = 240;
                              break;
                    case 'G':   y = 440;
                              break;
                    case 'T':   y = 640;
                              break;
                    case 'N':   y = 840;
                              break;
                    default:  y = 1040;                             
                              break;
                }
                if (Vrcholy.get(i).referencia){
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=yellow;");
                    nodes.add(node);                                
                }else{
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=cyan;");
                    nodes.add(node);                                
                }
                
            }            
            
            int n = Vrcholy.size();
            for (int i=0; i<n; i++) {
                 int m = Vrcholy.get(i).predchodcovia.size();
                    for(int j=0; j<m; j++) {
                        int index = Vrcholy.get(i).predchodcovia.get(j);
                        if (Vrcholy.get(i).zmena.equals(Vrcholy.get(index).zmena)){
                            mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), "rounded=2;edgeStyle=orthogonalEdgeStyle;strokeWidth=2;");
                            }else{
                                mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), "strokeWidth=3;");                                                   
                        }                             
                    }
                }
        }finally{
            mxgraf.getModel().endUpdate();
        }
    }    
    
    /**
     *
     * @param initX
     * @param initY
     */
    public static void spravRedukovanyGraf(int initX, int initY){     
        // inicializujeme graf
        mxgraf = new mxGraph();  
        Object parent = mxgraf.getDefaultParent();
        mxgraf.getModel().beginUpdate();
        ArrayList<Object> nodes = new ArrayList();
        //naplnime ho vrcholmi                                
        int x = initX, 
            staraPozicia = 0;
        try{
            for(int i=0;i<Vrcholy.size();i++){                
                if (staraPozicia != Vrcholy.get(i).pozicia){
                    staraPozicia = Vrcholy.get(i).pozicia;
                    x = x+100;                          
                }
                int y = initY;
                switch (Vrcholy.get(i).zmena.charAt(0)){
                    case 'A': y = 40;                                
                              break;
                    case 'C': y = 240;
                              break;
                    case 'G':   y = 440;
                              break;
                    case 'T':   y = 640;
                              break;
                    case 'N':   y = 840;
                              break;
                    default:  y = 1040;                             
                              break;
                }
                if (Vrcholy.get(i).referencia){
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=yellow;");
                    nodes.add(node);                                
                }else{
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=cyan;");
                    nodes.add(node);                                
                }
                
            }            
            
            int n = Vrcholy.size();
            for (int i=0; i<n; i++) {
                 int m = Vrcholy.get(i).predchodcovia.size();
                    for(int j=0; j<m; j++) {
                        int index = Vrcholy.get(i).predchodcovia.get(j);   
                        String farba = "";
                        if ((j<Vrcholy.get(i).vybraty_predchodcovia.size())&&(index==Vrcholy.get(i).vybraty_predchodcovia.get(j))){
                            farba = "strokeColor=red;"; 
                             if (Vrcholy.get(i).zmena.equals(Vrcholy.get(index).zmena)){
                            mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), "rounded=2;edgeStyle=orthogonalEdgeStyle;strokeWidth=2;"+farba);
                            }else{
                                mxgraf.insertEdge(parent, "", "", nodes.get(index), nodes.get(i), "strokeWidth=3;" + farba);
                             }

                        }                             
                    }
                }
        }finally{
            mxgraf.getModel().endUpdate();
        }
    }        
    
    public static void filtrujGraf(double minVahaVrchola, int minVahaHrany) throws IOException{
    BufferedWriter writer = new BufferedWriter(new FileWriter("linear.txt"));
         for(int i=0;i<(gen.length()*5);i++){
             int pozicia_i = (int) i / (int) 5;
             int baza_i = i % 5;
             int vaha_i = 0;
             boolean referencia_i = false;
             String zmena_i = "";
             switch (baza_i){
                case 0:   if(tabulkaVrcholov[pozicia_i].A>0) {                                
                            vaha_i = tabulkaVrcholov[pozicia_i].A;
                            zmena_i = "A";
                            if (typVrcholov[pozicia_i].A>0){
                                referencia_i = true;
                            }
                          }
                          break;
                case 1:   if(tabulkaVrcholov[pozicia_i].C>0) {                                
                            vaha_i = tabulkaVrcholov[pozicia_i].C;
                            zmena_i = "C";
                            if (typVrcholov[pozicia_i].C>0){
                                referencia_i = true;
                            }
                          }
                          break;
                case 2:   if(tabulkaVrcholov[pozicia_i].G>0) {                                
                            vaha_i = tabulkaVrcholov[pozicia_i].G;
                            zmena_i = "G";
                            if (typVrcholov[pozicia_i].G>0){
                                referencia_i = true;
                            }
                          }
                          break;
                case 3:   if(tabulkaVrcholov[pozicia_i].T>0) {                                
                            vaha_i = tabulkaVrcholov[pozicia_i].T;
                            zmena_i = "T";
                            if (typVrcholov[pozicia_i].T>0){
                                referencia_i = true;
                            }
                          }
                          break;
                case 4:   if(tabulkaVrcholov[pozicia_i].N>0) {                                
                            vaha_i = tabulkaVrcholov[pozicia_i].N;
                            zmena_i = "N";
                            if (typVrcholov[pozicia_i].N>0){
                                referencia_i = true;
                            }
                          }
                          break;
                default:  zmena_i = "N";
                          break;
            }
            double pomer = (double) vaha_i / (double) tabulkaVrcholov[pozicia_i].celkom;             
            boolean varianta = tabulkaVrcholov[pozicia_i].varianta(zmena_i, minVahaVrchola);
            if ((referencia_i && varianta) || (pomer > minVahaVrchola) && ((referencia_i && varianta)||(!referencia_i))){                                            
                Vrcholy.add(new Vrchol(zmena_i, pozicia_i, vaha_i, i, referencia_i));
                for(int j=0;j<(gen.length()*5);j++){
                    int pozicia_j = (int) j / (int) 5;
                    int baza_j = j % 5;
                    int vaha_j = 0;
                    String zmena_j = "";
                    boolean referencia_j = false;
                    switch (baza_j){
                       case 0:   if(tabulkaVrcholov[pozicia_j].A>0) {                                
                                   vaha_j = tabulkaVrcholov[pozicia_j].A;
                                   zmena_j = "A";
                                   if (typVrcholov[pozicia_j].A>0){
                                        referencia_j = true;
                                    }
                                 }
                                 break;
                       case 1:   if(tabulkaVrcholov[pozicia_j].C>0) {                                
                                   vaha_j = tabulkaVrcholov[pozicia_j].C;
                                   zmena_j = "C";
                                   if (typVrcholov[pozicia_j].C>0){
                                        referencia_j = true;
                                    }
                                 }
                                 break;
                       case 2:   if(tabulkaVrcholov[pozicia_j].G>0) {                                
                                   vaha_j = tabulkaVrcholov[pozicia_j].G;
                                   zmena_j = "G";
                                   if (typVrcholov[pozicia_j].G>0){
                                        referencia_j = true;
                                    }
                                 }
                                 break;
                       case 3:   if(tabulkaVrcholov[pozicia_j].T>0) {                                
                                   vaha_j = tabulkaVrcholov[pozicia_j].T;
                                   zmena_j = "T";
                                   if (typVrcholov[pozicia_j].T>0){
                                        referencia_j = true;
                                    }
                                 }
                                 break;
                       case 4:   if(tabulkaVrcholov[pozicia_j].N>0) {                                
                                   vaha_j = tabulkaVrcholov[pozicia_j].N;
                                   zmena_j = "N";
                                   if (typVrcholov[pozicia_j].N>0){
                                        referencia_j = true;
                                    }
                                 }
                                 break;
                       default:  zmena_j = "???";
                                 break;
                   } 
                    
                    double pomer_j = (double) vaha_j / (double) tabulkaVrcholov[pozicia_j].celkom;
                    boolean varianta_j = tabulkaVrcholov[pozicia_j].varianta(zmena_j, minVahaVrchola);
                    if ((referencia_j && varianta_j) || (pomer_j > minVahaVrchola) && ((referencia_j && varianta_j)||(!referencia_j))){                                        
                        int vahaHrany = maticaSusednosti[i][j];
                        if ((vahaHrany > minVahaHrany) &&(pozicia_i <= pozicia_j)){
                            writer.write("1 ");
                        } else {
                            writer.write("0 ");
                        }
                    }
                }
                writer.write("\n");
            }
        }

        writer.flush();
        writer.close();
        
        //inicializacia pola v ktorom budu ulozene vybrate hrany
        vybrate_hrany = new int[Vrcholy.size()][Vrcholy.size()];
        for (int i=0; i<Vrcholy.size(); i++){
            for (int j=0; j<Vrcholy.size(); j++){
                vybrate_hrany[i][j] = 0;
            }
        }        
        
    }
    
    
    public static void ZapisDoSuboru(String text)throws IOException {
        FileWriter w = new FileWriter("vystup.txt");
        BufferedWriter bw = new BufferedWriter(w);
            bw.write(text + "\n");
            // zavretie suboru je potrebne aby sa data zapisali na disk 
            bw.flush();
            bw.close();        
    }
    
    
    public static void predchodcoviaNasledovnici(int minVahaHrany){
    int n = Vrcholy.size();
    for (int i=0; i<n; i++) {
        for (int j=i-1; j>=0; j--) {
            int ii = Vrcholy.get(i).index;
            int jj = Vrcholy.get(j).index;
            int vahaHrany = maticaSusednosti[jj][ii];            
            if ((vahaHrany > minVahaHrany) && (Vrcholy.get(i).pozicia != Vrcholy.get(j).pozicia)) {
                Vrcholy.get(i).predchodcovia.add(j);
            }
        }
    
        for (int j=i+1; j<n; j++) {
            int ii = Vrcholy.get(i).index;
            int jj = Vrcholy.get(j).index;
            int vahaHrany = maticaSusednosti[ii][jj];            
            if ((vahaHrany > minVahaHrany) && (Vrcholy.get(i).pozicia != Vrcholy.get(j).pozicia)) {
                Vrcholy.get(i).nasledovnici.add(j);
            }	
        }
    }
}
    
    public static void redukujGraf(){
        int n = Vrcholy.size();        
                
        for (int i=0; i<n; i++) {            
            int m = Vrcholy.get(i).predchodcovia.size();
            Vrcholy.get(i).set_colors.add(i);
            for(int j=0; j<m; j++) {                                
                int predchodca = Vrcholy.get(i).predchodcovia.get(j);                
                if(!(Vrcholy.get(i).set_colors.contains(predchodca))){               
                    Vrcholy.get(i).vybraty_predchodcovia.add(Vrcholy.get(i).predchodcovia.get(j));                    
                    vybrate_hrany[Vrcholy.get(i).predchodcovia.get(j)][i] = 1;
                    Vrcholy.get(i).set_colors.addAll(Vrcholy.get(predchodca).set_colors);                                                       
                }            
            }
        }
    }
    
    
    /**
     * Inicializuje globalne premenne
     * @param minVrchol minimalna vaha vrchola
     * @param minHrana minimalna vaha hrany 
     */
    public static void inicializuj(double minVrchol, int minHrana){
        minVahaVrchola = minVrchol;
        minVahaHrany = minHrana;
        zarovnania = new ArrayList();
        ready = new ArrayList();
        gen = "";         
        mxgraf = new mxGraph();    
        Vrcholy = new ArrayList<Vrchol>();              
    }
    
    /**
     * Inicializuje globalne polia
     * Vzhladom na to, ze potrebujeme poznat dlzku genu, musime predtym spravit nacitanie zarovnani     
     */
    public static void inicializujPolia(){ 
        tabulkaVrcholov = new Policko[gen.length()];  
        for (int i=0; i<gen.length(); i++){
            Policko p = new Policko();
            tabulkaVrcholov[i] = p;
        }
        
        typVrcholov = new Policko[gen.length()];  
        for (int i=0; i<gen.length(); i++){
            Policko p = new Policko();
            typVrcholov[i] = p;
        }
        
        maticaSusednosti = new int[gen.length()*5][gen.length()*5];
        for (int i=0; i<(gen.length()*5); i++){
            for (int j=0; j<(gen.length()*5); j++){
                maticaSusednosti[i][j] = 0;
            }
        }
    }
    
    
     public static void demo1(){
        minVahaVrchola = 1200;
        minVahaHrany = 1200;
        zarovnania = new ArrayList();
        ready = new ArrayList();
        gen = "AAAAAAAAAA";         
        mxgraf = new mxGraph();    
        Vrcholy = new ArrayList();  
        
        /*
        Vrcholy.add(new Vrchol("C", 0, 3000, 1, true));
        Vrcholy.add(new Vrchol("G", 0, 3000, 2, true));
        Vrcholy.add(new Vrchol("A", 1, 3000, 5, true));
        Vrcholy.add(new Vrchol("G", 1, 3000, 7, true));
        Vrcholy.add(new Vrchol("C", 2, 3000, 11, true));
        Vrcholy.add(new Vrchol("T", 2, 3000, 13, true));
        Vrcholy.add(new Vrchol("C", 3, 3000, 16, true));
        Vrcholy.add(new Vrchol("T", 3, 3000, 18, true));
        Vrcholy.add(new Vrchol("G", 4, 3000, 22, true));
        maticaSusednosti = new int[gen.length()*5][gen.length()*5];
        for (int i=0; i<(gen.length()*5); i++){
            for (int j=0; j<(gen.length()*5); j++){
                maticaSusednosti[i][j] = 0;           
            }        
        }
        
        maticaSusednosti[1][7] = 3000;
        maticaSusednosti[2][7] = 3000;
        maticaSusednosti[5][11] = 3000;
        maticaSusednosti[7][11] = 3000;
        maticaSusednosti[7][13] = 3000;
        maticaSusednosti[11][16] = 3000;
        maticaSusednosti[13][18] = 3000;
        maticaSusednosti[16][22] = 3000;
        maticaSusednosti[18][22] = 3000;
        */
        
        /*
        Vrcholy.add(new Vrchol("A", 0, 3000, 0, true));
        Vrcholy.add(new Vrchol("T", 1, 3000, 8, true));
        Vrcholy.add(new Vrchol("A", 2, 3000, 10, true));
        Vrcholy.add(new Vrchol("G", 3, 3000, 17, true));
        Vrcholy.add(new Vrchol("C", 4, 3000, 21, true));
        Vrcholy.add(new Vrchol("C", 5, 3000, 26, true));
        maticaSusednosti = new int[gen.length()*5][gen.length()*5];
        for (int i=0; i<(gen.length()*5); i++){
            for (int j=0; j<(gen.length()*5); j++){
                maticaSusednosti[i][j] = 0;           
            }        
        }
        
        maticaSusednosti[0][10] = 3000;
        maticaSusednosti[8][17] = 3000;
        maticaSusednosti[10][17] = 3000;
        maticaSusednosti[10][21] = 3000;
        maticaSusednosti[17][21] = 3000;
        maticaSusednosti[21][26] = 3000;
       */
        
        Vrcholy.add(new Vrchol("A", 0, 3000, 0, true));
        Vrcholy.add(new Vrchol("G", 0, 3000, 2, true));
        Vrcholy.add(new Vrchol("C", 1, 3000, 6, true));
        Vrcholy.add(new Vrchol("A", 2, 3000, 10, true));
        Vrcholy.add(new Vrchol("G", 2, 3000, 12, true));        
        maticaSusednosti = new int[gen.length()*5][gen.length()*5];
        for (int i=0; i<(gen.length()*5); i++){
            for (int j=0; j<(gen.length()*5); j++){
                maticaSusednosti[i][j] = 0;           
            }        
        }
        
        maticaSusednosti[0][6] = 3000;
        maticaSusednosti[0][10] = 3000;
        maticaSusednosti[2][6] = 3000;
        maticaSusednosti[2][10] = 3000;
        maticaSusednosti[2][12] = 3000;
        maticaSusednosti[6][10] = 3000;
        maticaSusednosti[6][12] = 3000;        
        
        vybrate_hrany = new int[Vrcholy.size()][Vrcholy.size()];
        for (int i=0; i<Vrcholy.size(); i++){
            for (int j=0; j<Vrcholy.size(); j++){
                vybrate_hrany[i][j] = 0;
            }
        }
    }    
     
    public static void spravMaticesusednosti() throws IOException {
        int[][] matica = new int[Vrcholy.size()][Vrcholy.size()];
        for (int i=0; i<(Vrcholy.size()); i++){
            for (int j=0; j<(Vrcholy.size()); j++){
                matica[i][j] = 0;
            }
        }
        for (int i=0; i<Vrcholy.size(); i++) {
                 int m = Vrcholy.get(i).predchodcovia.size();
                    for(int j=0; j<m; j++) {
                        int index = Vrcholy.get(i).predchodcovia.get(j);
                        matica [index][i] = 1;
                    }
        }
        
        BufferedWriter writer = new BufferedWriter(new FileWriter("grafVariantov.txt"));
            for (int i=0; i<Vrcholy.size(); i++){
                for (int j=0; j<Vrcholy.size(); j++){                     
                    int vaha = matica [i][j];
                    if (vaha > 0) {
                        writer.write("1 ");
                    } else {
                        writer.write("0 ");
                    }
                }
                writer.write("\n");
            }
            
            writer.flush();
            writer.close();
        
            
        for (int i=0; i<(Vrcholy.size()); i++){
            for (int j=0; j<(Vrcholy.size()); j++){
                matica[i][j] = 0;
            }
        }    
        
        int n = Vrcholy.size();
        for (int i=0; i<n; i++) {
            int m = Vrcholy.get(i).predchodcovia.size();
            for(int j=0; j<m; j++) {
                int index = Vrcholy.get(i).predchodcovia.get(j);   
                if ((j<Vrcholy.get(i).vybraty_predchodcovia.size())&&(index==Vrcholy.get(i).vybraty_predchodcovia.get(j))){                           
                    matica[index][i] = 1;                                                        
                }
            }
        }
        
        writer = new BufferedWriter(new FileWriter("redukovanyGrafVariantov.txt"));
            for (int i=0; i<Vrcholy.size(); i++){
                for (int j=0; j<Vrcholy.size(); j++){                     
                    int vaha = matica [i][j];
                    if (vaha > 0) {
                        writer.write("1 ");
                    } else {
                        writer.write("0 ");
                    }
                }
                writer.write("\n");
            }
            
            writer.flush();
            writer.close();
        
    } 
    
    public static void infoVrcholy() throws IOException{
        BufferedWriter writer = new BufferedWriter(new FileWriter("infoVrcholy.txt"));
            for (int i=0; i<Vrcholy.size(); i++){
                Vrchol v = Vrcholy.get(i);
                String riadok;                
                riadok = Integer.toString(v.pozicia) + "\t" + v.zmena + "\t" 
                         + Boolean.toString(v.referencia) + "\t" + Integer.toString(v.vaha);
                writer.write(riadok);
                writer.write("\n");
            }
            
            writer.flush();
            writer.close();
        
    }
    
    public static void nacitajGraf(String matica, String vr) throws FileNotFoundException, IOException {
        // o vrchole treba vediet: pozicia, zmena, referencia, vaha            
        Vrcholy = new ArrayList();
        BufferedReader reader = new BufferedReader(new FileReader(vr));
        String line = reader.readLine();
        
        while (line != null){            
            String[] parametre = line.split("\t");
            Vrchol v = new Vrchol(parametre[1], Integer.valueOf(parametre[0]), 
                    Integer.valueOf(parametre[3]), 0, Boolean.valueOf(parametre[2]));
            Vrcholy.add(v);
            line = reader.readLine();
        }
        
        reader.close();
        
        // inicializujeme graf
        mxgraf = new mxGraph();    
        Object parent = mxgraf.getDefaultParent();
        mxgraf.getModel().beginUpdate();
        ArrayList<Object> nodes = new ArrayList();
        //naplnime ho vrcholmi                                
        int x = 100, 
            staraPozicia = 0;
        try{
            for(int i=0;i<Vrcholy.size();i++){                
                if (staraPozicia != Vrcholy.get(i).pozicia){
                    staraPozicia = Vrcholy.get(i).pozicia;
                    x = x+100;                          
                }
                int y = 0;
                switch (Vrcholy.get(i).zmena.charAt(0)){
                    case 'A': y = 40;                                
                              break;
                    case 'C': y = 240;
                              break;
                    case 'G':   y = 440;
                              break;
                    case 'T':   y = 640;
                              break;
                    case 'N':   y = 840;
                              break;
                    default:  y = 1040;                             
                              break;
                }
                if (Vrcholy.get(i).referencia){
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=yellow;");
                    nodes.add(node);                                
                }else{
                    Object node = mxgraf.insertVertex(parent, null, (Vrcholy.get(i).zmena + " na: " +Integer.toString(Vrcholy.get(i).pozicia)+ "\n" +Integer.toString(Vrcholy.get(i).vaha)), x, y, 80, 30, "portConstraint=north;fillColor=cyan;");
                    nodes.add(node);                                
                }
                
            }
        
            // treba naplnit predchodcov vrchola                        
            reader = new BufferedReader(new FileReader(matica)); 
            line = reader.readLine();
            int pocet = Integer.valueOf(line);
            String[] farby = {"pink", "magenta","darkGray", "blue", "red", "black", "gray", "green", "yellow", "orange"};
            int[] hrubky = {24, 20, 16, 28, 24, 20, 16, 12 ,8, 4};
            while(pocet >0){ 
                maticaSusednosti = new int[Vrcholy.size()][Vrcholy.size()];
                for (int i=0; i<Vrcholy.size(); i++){
                    for (int j=0; j<Vrcholy.size(); j++){
                        maticaSusednosti[i][j] = 0;
                    }
                }
                String varianta = "";
                boolean prvy = true;
                for(int i=0; i<Vrcholy.size(); i++){
                    line = reader.readLine();                    
                    String[] susedia = line.split("\t");
                    for(int j=0; j<Vrcholy.size(); j++){
                        maticaSusednosti[i][j] = Integer.valueOf(susedia[j]);
                        if (maticaSusednosti[i][j] > 0) {
                            if (prvy) {
                                varianta = varianta + Vrcholy.get(i).zmena;
                                prvy = false;
                            }
                            varianta = varianta + Vrcholy.get(j).zmena;
                        }
                    }                      
                }        
                System.out.println(varianta);
                //nakreslenie hran                
                for(int i=0; i<Vrcholy.size(); i++){                     
                    for(int j=0; j<Vrcholy.size(); j++){
                        if (maticaSusednosti[i][j] == 1) {
                            String farba = "strokeColor=".concat(farby[farby.length - pocet] + ";");
                            farba = farba.concat("strokeWidth=" + Integer.toString(hrubky[hrubky.length - pocet]) + ";startArrow=none;endArrow=none;");
                            if (Vrcholy.get(i).zmena.equals(Vrcholy.get(j).zmena)){
                                mxgraf.insertEdge(parent, "", "", nodes.get(i), nodes.get(j), "curved=1;rounded=1;edgeStyle=orthogonalEdgeStyle;"+farba);
                            }else{
                                    mxgraf.insertEdge(parent, "", "", nodes.get(i), nodes.get(j), farba);
                            }
                        }
                    }
                }

                pocet--;
            }
            reader.close();
        }finally{
            mxgraf.getModel().endUpdate();
        }
    }
    
    public static void nakresliVarianty(String cesty, String info) throws FileNotFoundException, IOException{
        nacitajGraf(cesty, info);
        nakresliGraf("varianty.svg");
    }
    
    // simulacia transverzie
    public static String transverzia(char baza){
        String result = "";
        int sanca = (int) (Math.random() * 2);
        switch (baza){
                    case 'A': if (sanca == 0) {
                                result = "C";    
                              } else {result = "T";}
                              break;
                    case 'C': if (sanca == 0) {
                                result = "A";    
                              } else {result = "G";}
                              break;
                    case 'G': if (sanca == 0) {
                                result = "C";    
                              } else {result = "T";}
                              break;
                    case 'T': if (sanca == 0) {
                                result = "A";    
                              } else {result = "G";}
                              break;                    
                    default: break;
                }
        return result;
    }
    
    // simulacie tranzicie
    public static String tranzicia(char baza){
        String result = "";        
        switch (baza){
                    case 'A': result = "G";
                              break;
                    case 'C': result = "T";
                              break;
                    case 'G': result = "A";
                              break;
                    case 'T': result = "C";
                              break;                    
                    default: break;
                }
        return result;
    }
    
    public static int Baza2Int (char baza) {
        int result = -1;
        switch (baza){
                    case 'A': result = 0;
                              break;
                    case 'C': result = 1;
                              break;
                    case 'G': result = 2;
                              break;
                    case 'T': result = 3;
                              break;                    
                    default:  break;
            }
        return result;
    }
    
    
    public static String Int2Baza (int b) {
        String result = "";       
        switch (b){
                    case 1: result = "A";
                              break;
                    case 2: result = "C";
                              break;
                    case 3: result = "G";
                              break;
                    case 4: result = "T";
                              break;  
                    case 5: result = "A";
                              break;
                    case 10: result = "C";
                              break;
                    case 15: result = "G";
                              break;
                    case 20: result = "T";
                              break;
                    default:  break;
            }
        return result;
    }
    
    public static String [] simulator(int dlzkaReferencie, int pocetVariantov, int pocetSNP, int konzistentnost, int k, int vzdialenost){
        // inicializacia globalnych premennych
        minVahaVrchola = 120;
        minVahaHrany = 120;
        zarovnania = new ArrayList();
        ready = new ArrayList();
        gen = "";         
        mxgraf = new mxGraph();    
        Vrcholy = new ArrayList();  
        
        //pocitanie indexov vrchola                
                
        
        // vygenerovanie nahodnej referencnej sekvencie
        for (int i = 0; i < dlzkaReferencie; i++) {
            int baza = (int) (Math.random() * 4);
            switch (baza){
                    case 0:  gen = gen + "A";                                
                              break;
                    case 1:  gen = gen + "C";
                              break;
                    case 2:  gen = gen + "G";
                              break;
                    case 3:  gen = gen + "T";
                              break;                    
                    default: gen = gen;                             
                              break;
            }
        }
        
        //vygenerovanie variantov referencneho genu        
        String [] varianty = new String[pocetVariantov]; 
        ArrayList<Integer> [] nejednoznacnePozicie = new ArrayList [pocetVariantov];
        ArrayList<String> [] alternativy = new ArrayList [pocetVariantov];
        //tabulka vrcholov
        int [] tabulka = new int[gen.length() * 4];
        
        for (int i = 0; i < (gen.length() * 4); i++) {
            tabulka[i] = 0;
        }
        
        for (int i = 0; i < pocetVariantov; i++) {
            // inicializujeme variantu
            varianty[i] = gen;
            nejednoznacnePozicie[i] = new ArrayList<Integer>();
            alternativy [i] = new ArrayList<String>();
            
            // pomasirujeme variantu
            for (int j = 0; j < pocetSNP; j++) {
                
                //hodime si kockou ktorou urcime zmenu a jej suvislost
                int pozicia = (int) (Math.random() * dlzkaReferencie);
                int sanca = (int) (Math.random() * 100);
                
                //zapracujeme suvislost a zmenime bazu
                String novaBaza = "";
                char baza = varianty[i].charAt(pozicia);
                if (sanca > konzistentnost){                    
                    novaBaza = transverzia(baza);
                } else {                    
                    novaBaza = tranzicia(baza);
                }
                
                //zmenime danu bazu varianty za novu
                String novaVarianta = varianty[i].substring(0, pozicia) + novaBaza + varianty[i].substring(pozicia+1);
                varianty[i] = novaVarianta;
                
                //pridame vrcholy do grafu varaintov
                int vr = pozicia*4 + Baza2Int(novaBaza.charAt(0));
                nejednoznacnePozicie[i].add(pozicia);
                tabulka[vr] = (Baza2Int(novaBaza.charAt(0))+1);
            }                        
        }
        
        
        //pridame referencne vrcholy
        
        //musime zistit ktore nejednoznacne pozicie nie su obsiahnute vo vsetkych variantach
        //cize sa pozrieme na nejadnoznacnu poziciu v variante
        //nasledne sa pozrieme ci ju maju aj ostatne varianty
        // ak ju nejaky variant nema potom pridame na toto miesto bazu z referencnej sekvencie
        for (int i = 0; i<varianty.length; i++) {
            for(int j = 0; j<varianty.length; j++) {
                int poceti = nejednoznacnePozicie[i].size();                
                for(int pi = 0; pi < poceti; pi++) {
                    int poziciai = nejednoznacnePozicie[i].get(pi);                    
                    if ((!(nejednoznacnePozicie[j].contains(poziciai)))) {
                        char bazai = gen.charAt(poziciai);
                        int vr = poziciai*4 + Baza2Int(bazai);
                        nejednoznacnePozicie[j].add(poziciai);
                        // oznacenie referencnych vrcholov v tabulke vrcholov
                        // ich hodnota je 5 nasobok povodnej hodnoty
                        tabulka[vr] = 5*(Baza2Int(bazai)+1);
                    }                    
                }
            }
        }                
        
        //vyrobime graf variantov        

        //vloz vrcholy
        for (int i = 0; i< (gen.length() * 4); i++){
            String baza = Int2Baza(tabulka[i]);
            int pozicia = (int) i / (int) 4;
            //treba odfiltrovat situacie ked sa mutacie znegovali t.j.
            
            // treba zistiť ci je to skutocna alternativa
            int skutocna = 0;
            
            //treba overit ci sa dana alternativa aj nachadza v nejakom variante
            int zastupena = 0;
            for (int v = 0; v < pocetVariantov; v++) {
                if (!((String.valueOf(varianty[v].charAt(pozicia)).equals(baza)))) {
                    skutocna++;
                }
            }
            for (int v = 0; v < pocetVariantov; v++) {
                if ((String.valueOf(varianty[v].charAt(pozicia)).equals(baza))) {
                    zastupena++;
                }
            }            
            if ((tabulka[i] > 0) && (skutocna > 0) &&(zastupena > 0)){                                            
                boolean ref = false;
                if (tabulka[i] > 4) {
                    ref = true;
                }
                int index = pozicia*5 + Baza2Int(baza.charAt(0));
                Vrcholy.add(new Vrchol(baza, pozicia, 3000, index, ref));
                for(int var = 0; var < pocetVariantov; var++) {
                    String bazaVar = String.valueOf(varianty[var].charAt(pozicia));
                    if (nejednoznacnePozicie[var].contains(pozicia) && (baza.equals(bazaVar))) {
                        alternativy[var].add(baza);
                    }
                }
            }            
        }
        
        //inicializujeme hrany
        maticaSusednosti = new int[gen.length()*5][gen.length()*5];
        for (int i=0; i<(gen.length()*5); i++){
            for (int j=0; j<(gen.length()*5); j++){
                maticaSusednosti[i][j] = 0;           
            }        
        }                        
        
        //pridame hrany za kazdu variantu
        for (int i=0; i<varianty.length; i++) {         
            //postupne pridavame hrany za kazdu alternativu vo variante
            for(int j=0; j<varianty[i].length(); j++){                
                // zistime ci sa jedna o nejednoznacnu poziciu
                if (nejednoznacnePozicie[i].contains(j)) {                  
                    
                    ArrayList<Vrchol> uchadzac = new ArrayList<Vrchol>();
                    //najdeme vrcholy s ktorymi je alternativa prepojena
                    // hladame vrcholy z grafu, ktori by mohli byt potencialni kandidati
                    int minimum = dlzkaReferencie;                                        
                    for (int v = 0; v < Vrcholy.size(); v++) {
                        Vrchol vrchol = Vrcholy.get(v);
                        int poziciaV = vrchol.pozicia;
                        String zmenaV = vrchol.zmena,
                                bazaVar = String.valueOf(varianty[i].charAt(poziciaV));
                        if ((poziciaV >= j) && (poziciaV <= (j+vzdialenost)) && (zmenaV.equals(bazaVar))) {                            
                            uchadzac.add(vrchol);
                        }                        
                    }                                        
                    
                    // uchadzacov prepojime kazdeho s kazdym
                    for(Vrchol l : uchadzac){
                        for(Vrchol m : uchadzac){                            
                            int vzd = Math.abs(m.pozicia - l.pozicia);
                            if ((vzd < minimum) && (!(l.equals(m)))) {
                                minimum = vzd;
                            }
                        }
                        for(Vrchol m : uchadzac){
                            int stastlivec = (int) (Math.random() * 100);
                            if ((l.index < m.index) && ((stastlivec > k) || (Math.abs(m.pozicia - l.pozicia) <= (minimum+1)))) {
                                maticaSusednosti[l.index][m.index] = 30000;
                            }
                        }
                    } 
                }                              
            }
        }
        
        //inicializujeme vybrate hrany
        vybrate_hrany = new int[Vrcholy.size()][Vrcholy.size()];
        for (int i=0; i<Vrcholy.size(); i++){
            for (int j=0; j<Vrcholy.size(); j++){
                vybrate_hrany[i][j] = 0;
            }
        }
        
        // vratime vygenerovane varianty
        String [] var = new String[(2*pocetVariantov)];
        for (int i = 0; i < pocetVariantov; i++) {
            var[i] = varianty[i];
        }
        for (int i = 0; i < pocetVariantov; i++) {
            String obmena = "";
            for(int j = 0; j < alternativy[i].size(); j++) {
                obmena = obmena + alternativy[i].get(j);
            }
            var[(pocetVariantov+i)] = obmena;
        }
        return var;
    }

    public static void simuluj(int dlzkaReferencie, int pocetVariantov, int pocetSNP, int konzistentnost, int k, int vzdialenost) throws IOException{
        //demo1(); 
        // nasimuluj
        String [] varianty = simulator(dlzkaReferencie, pocetVariantov, pocetSNP, konzistentnost, k, vzdialenost);
        
        // spracuj nasimulovane varianty
        predchodcoviaNasledovnici(minVahaHrany);
        redukujGraf();
        spravMaticesusednosti();
        infoVrcholy();        
        spravGraf(100, 0);            
        nakresliGraf("grafVariantov.svg");
        spravRedukovanyGraf(100, 0);           
        nakresliGraf("redukovanyGraf.svg");  
        
        //vypis co si vygeneroval
        System.out.println("Gen:" + gen);
        for (int i = 0; i < varianty.length; i++) {
            System.out.println(varianty[i]);
        }
    }        
    
    /**
     * Vygeneruje graf variantov a redukovany graf variantov na zaklade zarovnania, vstupnych segmentov k referencnej sekvencii genu, pochadzajuceho z Blat-u
     * @param minVrchol minimalna vaha vrchola - percentualne filtrovanie
     * @param minHrana minimalna vaha hrany = 0 kedze hrany nefiltrujeme
     * @param zarovnanie meno suboru v ktorom sa nachadza vystup z algoritmu Blat (format psl)
     * @param read meno suboru v ktorom sa nachadzaju segmenty (format fa)
     * @param g meno suboru v ktorom sa nachadza referencna sekvencia genu (format fa)
     * @param kvalita pocet baz, ktore su rovnake v sekvencii segmentu a useku ku ktoremu sa dany segment zarovnal (ide o parameter match vo formate psl)
     */
    public static void vytvorGrafy(double minVrchol, int minHrana, String zarovnanie, String read, String g, int kvalita) throws IOException, FileNotFoundException, Exception{                      
        inicializuj(minVrchol, minHrana);      
        nacitaj(zarovnanie, read, g, kvalita);          
        inicializujPolia();        
        spracuj();         
        filtrujGraf(minVahaVrchola, minVahaHrany);     
        predchodcoviaNasledovnici(minVahaHrany);
        redukujGraf();
        spravMaticesusednosti();
        infoVrcholy();        
        spravGraf(100, 0);            
        nakresliGraf("grafVariantov.svg");
        spravRedukovanyGraf(100, 0);           
        nakresliGraf("redukovanyGraf.svg"); 
    }
    
    public static void main(String[] args) throws FileNotFoundException, IOException, Exception{                                                    
        //vytvorGrafy(0.20, 0, "aln.psl", "selected-reads.fa", "fdh-dna.fa", 90);
        
        //nakresliVarianty("CestyCplex.txt", "infoVrcholy.txt");
       
        // dlzkaReferencie, pocetVariantov, pocetSNP, konzistentnost, k = s akou pst vyradime hranu, vzdialenost
        simuluj(30, 6, 15, 160, 70, 60);
                
        //z poskaladania variant  ako vystup zmeny v jednotlivych variantach
        //System.out.print(spocitaj());
        
        System.out.print("Hotovo\n" + "\n");                        
    }
}    